#!/usr/bin/perl
#
# TeleX10 V0.2
# (c) 2001-2004 Ian Wilkinson
# Based on
# BlueLava v0.3
# (c) 1999  Bruce Locke  (blocke@shivan.org)
#
# Released under the GPL v2... see COPYING for details
# This software comes without any warranty...
#

#
# wmlgen.pl contains 99% of the wml generating code
#

# stuff that must be set up after reading configuration file


sub wmlgen_init
{

$TeleX10_version="TeleX10 V0.2 based on BlueLava v0.3 by Bruce A. Locke";
$bluelava_url = $config_settings{"bluelava_baseurl"};

$wml_include_path = $config_settings{"bluelava_html"};


}

# cat_file: equivalent to  cat filename  in unix

sub cat_file
{

print "$filename";
 
local ($filename) = @_;
my ($line);

open (CATFILE, $filename);

while (defined ($line = <CATFILE>))
 {
          print "$line";
 }
  
close(CATFILE);
}
 

sub wml_bluelava_redirect
{
local ($params) = @_;

print ("Location: telex10.wml","$params\n");
print "Connection: close\n";
print "Content-Type: text/vnd.wap.wml\n\n";

print <<END_OF_WML
<?xml version="1.0"?>
<!DOCTYPE wml PUBLIC "-//WAPFORUM//DTD WML 1.1//EN" "http://www.wapforum.org/DTD/wml_1.1.xml">
<wml><template><do type="prev" label="Back"><prev/></do></template>
<card id="mainmenu" title="TeleX10">
<p align=\"center\">
302 Found<br/>
END_OF_WML
;

print ("The document has moved <a href=\"telex10.wml", "$params\">here</a>.</p>\n");
print "</p></card></wml>\n";
}


#
#  *** GENERATION OF STATUS SCREEN ***
#

sub wml_header
{
	cat_file ("$wml_include_path/header.wml");
}

sub wml_footer
{
	cat_file ("$wml_include_path/footer.wml");
}




sub wml_table_device
{

local ($device_name, $device_id, $device_type, $room_name) = @_;


print "$device_name [";

if ($device_type eq "lamp")
{
	print "Lamp";
} 
elsif ($device_type eq "appliance")
{
	print "Appliance";
}
else
{
	print "Unknown";
}

print "] - ";

print "<a href=\"telex10.wml?action=on&amp;device=$device_id&amp;room=$room_name\">On</a> ";

print "<a href=\"telex10.wml?action=off&amp;device=$device_id&amp;room=$room_name\">Off</a> ";

if ($device_type eq "lamp")
{
	print "<a href=\"telex10.wml?action=bright&amp;device=$device_id&amp;room=$room_name\">Brighten</a> ";
	print "<a href=\"telex10.wml?action=dim&amp;device=$device_id&amp;room=$room_name\">Dim</a> ";
}

print "<br/>";

}

sub html_link_roomfunc
{
local ($linktext, $action, $room) = @_;

print "<td colspan=1 bgcolor=\"$row_color_hex\">";
print "<font size=\"-1\">";
print "<a href=\"$bluelava_url/bluelava.cgi?action=$action&room=$room\">$linktext</a>";
print "</td>";
}

sub html_table_room_options
{

local ($room_name) = @_; 
local ($bluelava_url) = $config_settings{"bluelava_baseurl"};

print "<tr>";
print "<td colspan=2 bgcolor=\"$row_color_hex\">";
print "<br></td>";

html_link_roomfunc("Lights On", "lon", $room_name);
html_link_roomfunc("Lights Off", "loff", $room_name);

html_link_roomfunc("All On", "aon", $room_name);
html_link_roomfunc("All Off", "aoff", $room_name);

print "</td></tr>";


}

sub wml_room_select
{
	local ($message) = @_;
	print "<card id=\"mainmenu\" title=\"TeleX10\"><p align=\"center\">";
	if ($message ne "")
	{
		print "$message<br/>";
	}
	print "Select the Room<br/>";
	foreach $room (keys %config_rooms)
	{
		print "<a href=\"telex10.wml?room=$room\">$room</a><br/>";
	}
	#if (x10_status("") ne "" ) 
	#{
	#	print "<br/>Current Status<br/>";
	#	local($state,$housecode) = x10_status("I"); 
	#	print "$state<br/>Housecode: $housecode";
	#}
	print "</p></card>";
}

# html_status_table: generates the nice html table

sub wml_status_table
{

local ($message,$selectedroom) = @_;
local ($deviceptr, @devicelist, %devicehash, $device);

print "<card id=\"mainmenu\" title=\"TeleX10\"><p align=\"center\">";
if ($message ne "")
{
	print "$message<br/>";
}
print "Device [Type] - Action<br/>";


$deviceptr = $config_rooms{$selectedroom};
@devicelist = @$deviceptr;

foreach $device (@devicelist)
{
	%devicehash = %$device;

	wml_table_device($devicehash{"name"}, $devicehash{"id"}, $devicehash{"type"}, $selectedroom);
}

	print "</p></card>"
}


sub generate_roomselect_page
{
local ($message) = @_;

print "Content-type: text/vnd.wap.wml \n\n";

wml_header();
wml_room_select($message);
wml_footer();

}


#
# Generates the page!
#

sub generate_status_page
{
local ($message,$selectedroom) = @_;

print "Content-type: text/vnd.wap.wml \n\n";

wml_header();
wml_status_table($message,$selectedroom);
wml_footer();      

}


#
#  The following generates the "dialog boxes"
#

sub wml_notice
{

local ($notice_topic, $notice_message, $textcolor, $bgcolor) = @_;

print <<END_OF_HTML
<card id="mainmenu" title="TeleX10">
<p>
<b>$notice_topic</b>
<br/>
$notice_message
</p>
</card>
END_OF_HTML
;


}

sub wml_errormsg
{

local ($notice_topic, $notice_message) = @_;

print "Content-type: text/vnd.wap.wml \n\n";

wml_header();
wml_notice ($notice_topic, $notice_message, "#FFFFFF", "#FF0000");
wml_footer();
}



# end of wmlgen.pl
1;
